/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.build;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.CSSCorePlugin;
import com.aptana.css.core.internal.build.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.properties.css3.Css3Style;
import org.w3c.css.util.Utf8Properties;

public class AptanaCSSStyle
extends Css3Style {
    private static final String PROPERITES_FILE_NAME = "AptanaCSSProperties.properties";
    private static final Utf8Properties CSS_PROPERTIES = new Utf8Properties();
    private final Map<String, CssProperty> properties = new HashMap<String, CssProperty>();

    static {
        InputStream configStream = AptanaCSSStyle.class.getResourceAsStream(PROPERITES_FILE_NAME);
        try {
            CSS_PROPERTIES.load(configStream);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (String)Messages.AptanaCSSStyle_ERR_UnableToLoadProperties, (Throwable)e);
        }
    }

    public CssProperty getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public CssProperty getPropertyCascadingOrder(String propertyName) {
        CssProperty toReturn = this.properties.get(propertyName);
        return toReturn == null ? this.style.CascadingOrder(this.createNewDefaultInstance(propertyName), this.style, this.selector) : toReturn;
    }

    public void setProperty(String propertyName, CssProperty propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    private CssProperty createNewDefaultInstance(String propertyName) {
        String propertyClassName;
        block7: {
            if (StringUtil.isEmpty((String)propertyName)) {
                return null;
            }
            String nameToSearch = propertyName;
            if (propertyName.charAt(0) == '-') {
                nameToSearch = propertyName.substring(1);
            }
            if ((propertyClassName = CSS_PROPERTIES.getProperty(nameToSearch)) != null) break block7;
            return null;
        }
        try {
            return (CssProperty)Class.forName(propertyClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(MessageFormat.format(Messages.AptanaCSSStyle_ERR_CreatingNewInstance, ((Object)((Object)this)).getClass().getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(MessageFormat.format(Messages.AptanaCSSStyle_ERR_CreatingNewInstance, ((Object)((Object)this)).getClass().getName()), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(MessageFormat.format(Messages.AptanaCSSStyle_ERR_CreatingNewInstance, ((Object)((Object)this)).getClass().getName()), e);
        }
    }
}

